function [q,qd,qdd] = user_DrivenJoints(mbs_data,tsim)
% --------------------------
% UCL-CEREM-MBS
%
% @version MBsysLab_m 1.7.a
%
% Creation : 2005
% Last update : 30/09/2008
% -------------------------
%
%[q,qd,qdd] = user_DrivenJoints(mbs_data,tsim)
%
% mbs_data : multibody data structure
% tsim : current time
%
% q, qd, qdd : updated column vectors of generalized coordinates
%
%
% mbs_data.q : generalized coordinates [column vector]
% mbs_data.qd : generalized velocities [column vector]
% mbs_data.qdd : generalized accelerations [column vector]
% mbs_data.nqc : number of driven variables
% mbs_data.qc : indices of driven variables [column vector]

global MBS_user MBS_info

q   = mbs_data.q;
qd  = mbs_data.qd;
qdd = mbs_data.qdd;

%/*-- Begin of user code --*/

% Robot trajectory (harmonic motion in x, y, z of the platform)

f = 0.5;
om = 2*pi*f;
a = 0.2;

q(3) = 0.9+a*sin(om*tsim);
qd(3) = a*om*cos(om*tsim);
qdd(3) = -a*om^2*sin(om*tsim);

f = 1;
om = 2*pi*f;
a = 0.1;

q(1) = a*sin(om*tsim);
qd(1) = a*om*cos(om*tsim);
qdd(1) = -a*om^2*sin(om*tsim);

q(2) = a*cos(om*tsim);
qd(2) = -a*om*sin(om*tsim);
qdd(2) = -a*om^2*cos(om*tsim);

return